#!/bin/bash

IimBriefDescription="Mail Retreiver And InMail Preparations"

ORIGIN="
* Revision And Libre-Halaal CopyLeft -- Part Of ByStar -- Best Used With Blee
"

####+BEGIN: bx:dblock:bash:top-of-file :vc "cvs" partof: "bystar" :copyleft "halaal+brief"
typeset RcsId="$Id: mboxRetrieve.sh,v 1.1 2017-10-21 22:51:51 lsipusr Exp $"
# *CopyLeft*
# Copyright (c) 2011 Neda Communications, Inc. -- http://www.neda.com
# See PLPC-120001 for restrictions.
# This is a Halaal Poly-Existential intended to remain perpetually Halaal.
####+END:

__author__="
* Authors: Mohsen BANAN, http://mohsen.banan.1.byname.net/contact
"


####+BEGIN: bx:dblock:lsip:bash:seed-spec :types "seedActions.bash"
SEED="
*  /[dblock]/ /Seed/ :: [[file:/opt/public/osmt/bin/seedActions.bash]] | 
"
FILE="
*  /This File/ :: /de/bx/nne/dev-py/projs/fastrackhr/dsnGet/dsnGet.sh 
"
if [ "${loadFiles}" == "" ] ; then
    /opt/public/osmt/bin/seedActions.bash -l $0 "$@" 
    exit $?
fi
####+END:

_CommentBegin_
####+BEGIN: bx:dblock:global:file-insert-cond :cond "./blee.el" :file "/libre/ByStar/InitialTemplates/software/plusOrg/dblock/inserts/topControls.org"
*  /Controls/ ::  [[elisp:(org-cycle)][| ]]  [[elisp:(show-all)][Show-All]]  [[elisp:(org-shifttab)][Overview]]  [[elisp:(progn (org-shifttab) (org-content))][Content]] | [[file:Panel.org][Panel]] | [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] | [[elisp:(bx:org:run-me)][Run]] | [[elisp:(bx:org:run-me-eml)][RunEml]] | [[elisp:(delete-other-windows)][(1)]] | [[elisp:(progn (save-buffer) (kill-buffer))][S&Q]]  [[elisp:(save-buffer)][Save]]  [[elisp:(kill-buffer)][Quit]] [[elisp:(org-cycle)][| ]]
** /Version Control/ ::  [[elisp:(call-interactively (quote cvs-update))][cvs-update]]  [[elisp:(vc-update)][vc-update]] | [[elisp:(bx:org:agenda:this-file-otherWin)][Agenda-List]]  [[elisp:(bx:org:todo:this-file-otherWin)][ToDo-List]] 

####+END:
_CommentEnd_

_CommentBegin_
*      ================
k*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]] CONTENTS-LIST ################
*  [[elisp:(org-cycle)][| ]]  Notes         :: *[Current-Info:]*  Status, Notes (Tasks/Todo Lists, etc.) [[elisp:(org-cycle)][| ]]
_CommentEnd_

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_moduleDescription    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_moduleDescription {  cat  << _EOF_
*  [[elisp:(org-cycle)][| ]]  Xrefs         :: *[Related/Xrefs:]*  <<Xref-Here->>  -- External Documents  [[elisp:(org-cycle)][| ]]
**  [[elisp:(org-cycle)][| ]]  Panel        :: [[file:/libre/ByStar/InitialTemplates/activeDocs/bxServices/versionControl/fullUsagePanel-en.org::Xref-VersionControl][Panel Roadmap Documentation]] [[elisp:(org-cycle)][| ]]
*  [[elisp:(org-cycle)][| ]]  Info          :: *[Module Description:]* [[elisp:(org-cycle)][| ]]

_EOF_
			       }


_CommentBegin_
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]  *Seed Extensions*
_CommentEnd_

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  Imports       :: Prefaces (Imports/Libraries) [[elisp:(org-cycle)][| ]]
_CommentEnd_

. ${opBinBase}/opAcctLib.sh
. ${opBinBase}/opDoAtAsLib.sh
. ${opBinBase}/lpParams.libSh
. ${opBinBase}/lpReRunAs.libSh

. ${opBinBase}/fileParam.libSh


# PRE parameters


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  IIM Characteristic Definitions    [[elisp:(org-cycle)][| ]]
_CommentEnd_


G_myPanel=$(FN_prefix ${G_myName})-Panel.org

G_iimGroupingType=${IimGroupingType[pkged]}

G_iimCmndParts="
${IimCmndParts[common]}
${IimCmndParts[param]}
"

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  iimParam_userName    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function iimParam_userName {
    if [ $# -eq 0 ] ; then    
	IimParam userName=(
	    [name]="userName"
	    [value]="sa-20000"
	    [type]="string"
	    [description]="Account name used for IMAP server login"
	    [enums]="my_enums" 
	)
    fi

    function my_enums { cat  << _EOF_
UserInput
sa-20000
_EOF_
		      }

    if [ $# -eq 1 ] ; then $1; lpReturn; fi
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  iimParam_userPasswd    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function iimParam_userPasswd {
    if [ $# -eq 0 ] ; then    
	IimParam userPasswd=(
	    [name]="userPasswd"
	    [value]="shouldBeEncripted"
	    [type]="string"
	    [description]="Account passwd used for IMAP server login"
	    [enums]="my_enums" 
	)
    fi

    function my_enums { cat  << _EOF_
UserInput
_EOF_
		      }

    if [ $# -eq 1 ] ; then $1; lpReturn; fi
}

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  iimParam_imapServer    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function iimParam_imapServer {
    if [ $# -eq 0 ] ; then    
	IimParam imapServer=(
	    [name]="imapServer"
	    [value]="imapServerValue"
	    [type]="string"
	    [description]="domain name or ip address of the IMAP server"
	    [enums]="my_enums" 
	)
    fi

    function my_enums { cat  << _EOF_
UserInput
imap.mohsen.1.banan.byname.net
198.62.92.166
_EOF_
		      }

    if [ $# -eq 1 ] ; then $1; lpReturn; fi
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  iimParam_mailDirPath    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function iimParam_mailDirPath {
    if [ $# -eq 0 ] ; then    
	IimParam mailDirPath=(
	    [name]="mailDirPath"
	    [value]="~/Maildir"
	    [type]="string"
	    [description]="Location Of Maildir"
	    [enums]="my_enums" 
	)
    fi

    function my_enums { cat  << _EOF_
UserInput
~/Maildir
./var/Maildir
_EOF_
		      }

    if [ $# -eq 1 ] ; then $1; lpReturn; fi
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  iimParam_foldersInclude    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function iimParam_foldersInclude {
    if [ $# -eq 0 ] ; then    
	IimParam foldersInclude=(
	    [name]="foldersInclude"
	    [value]="envelope"
	    [type]="string"
	    [description]="List Of IMAP Folders To Inclue"
	    [enums]="my_enums" 
	)
    fi

    function my_enums { cat  << _EOF_
UserInput
test
fastrackhr
_EOF_
		      }

    if [ $# -eq 1 ] ; then $1; lpReturn; fi
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  iimParam_foldersExclude    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function iimParam_foldersExclude {
    if [ $# -eq 0 ] ; then    
	IimParam foldersExclude=(
	    [name]="foldersExclude"
	    [value]="None"
	    [type]="string"
	    [description]="List Of IMAP Folders To Exclude"
	    [enums]="my_enums" 
	)
    fi

    function my_enums { cat  << _EOF_
None
_EOF_
		      }

    if [ $# -eq 1 ] ; then $1; lpReturn; fi
}




_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  G_postParamHook    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function G_postParamHook {
    G_iimCapabilities="iimBash iimParams"

    return 0
}
    

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  Examples      :: Examples [[elisp:(org-cycle)][| ]]
_CommentEnd_


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_examples    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_examples {
    typeset extraInfo="-h -v -n showRun"
    #typeset extraInfo=""
    typeset runInfo="-p ri=lsipusr:passive"

    typeset examplesInfo="${extraInfo} ${runInfo}"

    visLibExamplesOutput ${G_myName} 
  cat  << _EOF_
$( examplesSeperatorTopLabel "${G_myName}" )
$( examplesSeperatorChapter "IIM Management Facilities" )
${G_myName} ${extraInfo} -i iimsInParamsUpdate
$( examplesSeperatorChapter "Offline IMAP Configuration" )
${G_myName} ${extraInfo} -i offlineimaprcStdout
${G_myName} ${extraInfo} -i offlineimaprcUpdate
${G_myName} ${extraInfo} -p userPasswd=passwd -p userName=sa-20000 -p mailDirPath=./var/Maildir -p imapServer=imap.mohsen.1.banan.byname.net -p foldersInclude=fastrackhr -p foldersExclude=None -i offlineimaprcStdout
${G_myName} ${extraInfo} -p userPasswd=passwd -p userName=sa-20000 -p mailDirPath=./var/Maildir -p imapServer=imap.mohsen.1.banan.byname.net -p foldersInclude=fastrackhr -p foldersExclude=None -i offlineimaprcUpdate
cat $(FN_absolutePathGet ~/.offlineimaprc)
$( examplesSeperatorChapter "Offline IMAP Execution" )
${G_myName} ${extraInfo} -i refreshOfflineImapMaildir
$( examplesSeperatorChapter "offlineimap Direct Invokations" )
offlineimap --info
offlineimap --dry-run
_EOF_
}

noArgsHook() {
  vis_examples
}

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  IIFs          :: Interactively Invokable Functions (IIF)s |  [[elisp:(org-cycle)][| ]]
_CommentEnd_

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  IIFs          :: Offline IMAP Configuration And Execution  |  [[elisp:(org-cycle)][| ]]
_CommentEnd_


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_offlineimaprcStdout    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_offlineimaprcStdout {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    local mailDirFullPath=$(FN_absolutePathGet ${mailDirPath})

    local thisFolder
    local foldersListStr=""
    
    for thisFolder in ${foldersInclude} ; do
	foldersListStr="'INBOX.${thisFolder}', ${foldersListStr}"
    done

    cat  << _EOF_
[general]
accounts = MyAccount
#pythonfile = .offlineimap.py

[Account MyAccount]
localrepository = LocalIMAP
remoterepository = RemoteIMAP
# autorefresh = 5
# postsynchook = notmuch new

[Repository LocalIMAP]
type = Maildir
localfolders =  ${mailDirFullPath}

[Repository RemoteIMAP]
type = IMAP
remotehost = ${imapServer}
remoteuser = ${userName}
remotepass = ${userPasswd}
ssl = no
nametrans = lambda name: re.sub('^INBOX.', '', name)
folderfilter = lambda name: name in [ ${foldersListStr} ]
# folderfilter = lambda name: name in [ 'INBOX.important', 'INBOX.work' ]
# folderfilter = lambda name: not (name in [ 'INBOX.spam', 'INBOX.commits' ])
# holdconnectionopen = yes
# maxconnections = 3
# foldersort = lld_cmp
_EOF_
    
    lpReturn
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_offlineimaprcUpdate    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_offlineimaprcUpdate {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    typeset thisConfigFile=$(FN_absolutePathGet ~/.offlineimaprc)

    FN_fileSafeKeep ${thisConfigFile}

    opDo eval vis_offlineimaprcStdout '>' ${thisConfigFile}

    opDo ls -l ${thisConfigFile}
}



_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_refreshOfflineImapMaildir    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_refreshOfflineImapMaildir {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    #if [ -d ~lsipusr/Maildir ] ; then
	#opDo rm -r ~lsipusr/Maildir
    #fi
    inBaseDirDo ~lsipusr offlineimap
    
    lpReturn
}



_CommentBegin_
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]  *End Of Editable Text*
_CommentEnd_

####+BEGIN: bx:dblock:bash:end-of-file :type "basic"
_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  Common        ::  /[dblock] -- End-Of-File Controls/ [[elisp:(org-cycle)][| ]]
_CommentEnd_
#+STARTUP: showall
#local variables:
#major-mode: sh-mode
#fill-column: 90
# end:
####+END:
