#!/bin/bash

IimBriefDescription="iimsProc.sh: A scattered IIM extensions based on seedIimsProc.sh"

ORIGIN="
* Revision And Libre-Halaal CopyLeft -- Part Of ByStar -- Best Used With Blee
"

####+BEGIN: bx:dblock:bash:top-of-file :vc "cvs" partof: "bystar" :copyleft "halaal+minimal"
typeset RcsId="$Id: iimsProc.sh,v 1.9 2017-11-21 03:03:34 lsipusr Exp $"
# *CopyLeft*
#  This is a Halaal Poly-Existential. See http://www.freeprotocols.org

####+END:

__author__="
* Authors: Mohsen BANAN, http://mohsen.banan.1.byname.net/contact
"
####+BEGIN: bx:dblock:lsip:bash:seed-spec :types "seedIimsProc.sh"
SEED="
*  /[dblock]/ /Seed/ :: [[file:/opt/public/osmt/bin/seedIimsProc.sh]] | 
"
FILE="
*  /This File/ :: /de/bx/nne/dev-py/iimsPkgs/remoteMailActions/envelopeDsn/iimsProc.sh 
"
if [ "${loadFiles}" == "" ] ; then
    /opt/public/osmt/bin/seedIimsProc.sh -l $0 "$@" 
    exit $?
fi
####+END:

_CommentBegin_
####+BEGIN: bx:dblock:global:file-insert-cond :cond "./blee.el" :file "/libre/ByStar/InitialTemplates/software/plusOrg/dblock/inserts/topControls.org"
*  /Controls/ ::  [[elisp:(org-cycle)][| ]]  [[elisp:(show-all)][Show-All]]  [[elisp:(org-shifttab)][Overview]]  [[elisp:(progn (org-shifttab) (org-content))][Content]] | [[file:Panel.org][Panel]] | [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] | [[elisp:(bx:org:run-me)][Run]] | [[elisp:(bx:org:run-me-eml)][RunEml]] | [[elisp:(delete-other-windows)][(1)]] | [[elisp:(progn (save-buffer) (kill-buffer))][S&Q]]  [[elisp:(save-buffer)][Save]]  [[elisp:(kill-buffer)][Quit]] [[elisp:(org-cycle)][| ]]
** /Version Control/ ::  [[elisp:(call-interactively (quote cvs-update))][cvs-update]]  [[elisp:(vc-update)][vc-update]] | [[elisp:(bx:org:agenda:this-file-otherWin)][Agenda-List]]  [[elisp:(bx:org:todo:this-file-otherWin)][ToDo-List]] 

####+END:
_CommentEnd_

_CommentBegin_
*      ================
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]] CONTENTS-LIST ################
*  [[elisp:(org-cycle)][| ]]  Info          :: *[Current-Info:]*  Status, Notes (Tasks/Todo Lists, etc.) [[elisp:(org-cycle)][| ]]
_CommentEnd_


_CommentBegin_
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]  *Seed Extensions*
_CommentEnd_


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || FmWk-Par  ::  IIM Profile / Characteristic Definitions    [[elisp:(org-cycle)][| ]]
_CommentEnd_

# Types are defined as associative arrays in /opt/public/osmt/lib/visLib.sh

G_iimGroupingType=${IimGroupingType[pkged]}

G_myPanel=$(FN_prefix ${G_myName})-Panel.org

G_iimCmndParts="
${IimCmndParts[common]}
"


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  Examples      :: Examples Hook Post [[elisp:(org-cycle)][| ]]
_CommentEnd_


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || FmWk-Func ::  examplesHookPost    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function examplesHookPost {
cat  << _EOF_
$( examplesSeperatorChapter "*Extentions* (examplesHookPost)" )
$( examplesSeperatorChapter "Top Level FULL Actions" )
${G_myName} ${extraInfo} -i icmsFullUpdate
${G_myName} ${extraInfo} -p runEnv=bxo -i icmsFullUpdate
${G_myName} ${extraInfo} -p runEnv=/var/icms -i icmsFullUpdate
${G_myName} ${extraInfo} -i pkgInfo         # Assumes the package has been initialized (fullUpdate)
${G_myName} ${extraInfo} -p runEnv=bxo -i icmsFullClean
${G_myName} ${extraInfo} -p runEnv=/var/icms -i icmsFullClean
$( examplesSeperatorChapter "Top Level Actions" )
${G_myName} ${extraInfo} -i icmsPkgPreps        # Does all preps but NO Panles
${G_myName} ${extraInfo} -p runEnv=/var/icms -i icmsPkgPreps
${G_myName} ${extraInfo} -i icmsPkgClean
${G_myName} ${extraInfo} -i icmsRunEnvPreps
${G_myName} ${extraInfo} -i icmsRunEnvClean
${G_myName} ${extraInfo} -i icmsRunEnvLinks
${G_myName} ${extraInfo} -i icmsRunEnvLinksRemove
$( examplesSeperatorChapter "Top Level Actions" )
${G_myName} ${extraInfo} -i icmsPanelsPreps    # Assumes icmsPkgPreps has been done
${G_myName} ${extraInfo} -i icmsPanelsClean
$( examplesSeperatorChapter "icmsPkg File Parameters" )
fileParamManage.py -i fileParamWrite ../pkgInfo/fp icmsPkgName marme.dev
fileParamManage.py -i fileParamRead ../pkgInfo/fp icmsPkgName
fileParamManage.py -i fileParamWrite ../pkgInfo/fp icmsPkgControlName marme.control
fileParamManage.py -i fileParamRead ../pkgInfo/fp icmsPkgControlName
fileParamManage.py -i fileParamWrite ../pkgInfo/fp icmsPkgControlBaseDir $(cd ../.. && pwd)/marme.control
fileParamManage.py -i fileParamRead ../pkgInfo/fp icmsPkgControlBaseDir
$( examplesSeperatorChapter "Some Local IIM Extensions" )
${G_myName} ${extraInfo} -i icmsPkgTarUpdateAtPlpc
${G_myName} ${extraInfo} -i old2New
$( examplesSeperatorChapter "*Perhaps Future Features Or Perhaps Obsoleted*" )
${G_myName} ${extraInfo} -i pkgInit $(cat _selectedIim)
${G_myName} ${extraInfo} -i defaultsTargetsAndParamsSet
${G_myName} ${extraInfo} -i iimsPkgPreps   # from visLib.sh sets up ./var/iimsPkg/iimsIn/paramsFp
$( examplesSeperatorChapter "*Templates Development*" )
----  Initial Templates Development ----
diff ./iimsProc.sh  /libre/ByStar/InitialTemplates/begin/templates/purposed/iims/bash/iimsProc.leaf.sh
cp ./iimsProc.sh  /libre/ByStar/InitialTemplates/begin/templates/purposed/iims/bash/iimsProc.leaf.sh
cp  /libre/ByStar/InitialTemplates/begin/templates/purposed/iims/bash/iimsProc.leaf.sh ./iimsProc.sh 
----  Initial Templates Development ----
diff ./Panel.org /libre/ByStar/InitialTemplates/begin/templates/purposed/iims/bash/common/beginPanel.org
cp ./Panel.org /libre/ByStar/InitialTemplates/begin/templates/purposed/iims/bash/common/beginPanel.org
cp /libre/ByStar/InitialTemplates/begin/templates/purposed/iims/bash/common/beginPanel.org ./Panel.org 
_EOF_
 return
}



_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Func      ::  icmsPkgBaseDirGet    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function icmsPkgBaseDirGet {
    local icmsPkgBaseDir=$(FN_absolutePathGet ..)    
    echo "${icmsPkgBaseDir}"
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Func      ::  icmsPkgNameGet    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function icmsPkgNameGet {
    local pkgName=$(fileParamManage.py -i fileParamRead ../pkgInfo/fp icmsPkgName)
    echo ${pkgName}
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Func      ::  icmsBxoBaseDirGet    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function icmsBxoBaseDirGet {
    local icmsBxoBaseDir=$( FN_absolutePathGet ../../.. )
    echo "${icmsBxoBaseDir}"
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  icmsPkgControlProfilesNameGet    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function icmsPkgControlNameGet {
    local parValue=$(fileParamManage.py -i fileParamRead ../pkgInfo/fp icmsPkgControlName)
    echo ${parValue}
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  icmsPkgControlProfilesBaseDirGet    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function icmsPkgControlBaseDirGet {
    local name=$(icmsPkgControlNameGet)
    echo $(FN_absolutePathGet ../../${name})
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Func      ::  icmsRunEnvBaseGet    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function icmsRunEnvBaseDirGet {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
Output the base path for runEnv
_EOF_
    }
    if [ -z "${runEnv}" ] ; then 
	runEnv="bxo"
    fi

    if [ "${runEnv}" == "bxo" ] ; then
	runEnv=$(icmsBxoBaseDirGet)
    fi
	
    echo "${runEnv}"
}



_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_pkgInfo    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_pkgInfo {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    local bxtObject=$(cat _objectType_)

    if [ ! -f _iimsList ] ; then
	EH_problem ""
	lpReturn
    fi

    local iimsList=$(cat _iimsList)

    ANT_raw "iimsList=${iimsList}"

    local iimLanguage=""
    local thisIim=""
    for thisIim in ${iimsList}; do
	iimLanguage=$( ${thisIim} -i iimLanguage)
	echo "${thisIim} -- ${iimLanguage}"
	
	if [ "${iimLanguage}" == "bash" ] ; then
	    opDo ${thisIim} -i iimGroupingType
	    opDo ${thisIim} -i iimCmndPartList
	elif [ "${iimLanguage}" == "python" ] ; then
	    #echo "NOTYET -- IIM-Profile can be retrieved with -i iim.groupingType etc"	    
	    #EH_problem "python -i iim.groupingType ${thisIim} -- Notyet"
	    continue
	else
	    EH_oops "${thisIim}"
	    continue
	fi
    done

    case "${bxtObject}" in
	"bxt.iim.bash.pkged")
	    ANT_cooked "Processed bxtObject=${bxtObject}"	    
	    ;;
	*)
	    ANT_cooked "Unprocessed bxtObject=${bxtObject}"
	    ;;
    esac
    
    opDo fileParamManage.py -i fileParamRead ../pkgInfo/fp icmsPkgName
    opDo fileParamManage.py -i fileParamRead ../pkgInfo/fp icmsPkgControlName
    opDo fileParamManage.py -i fileParamRead ../pkgInfo/fp icmsPkgControlBaseDir
    
    lpReturn
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsFullUpdate    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsFullUpdate {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    opDo vis_icmsPkgPreps
    opDo vis_icmsPanelsPreps    
}

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsFullClean    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsFullClean {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]
    
    #opDo vis_pkgDistClean

    opDo vis_icmsPkgClean
    opDo vis_icmsPanelsClean
}

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsPkgPreps    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsPkgPreps {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
** Invokes: vis_icmsPkgBaseLinks vis_icmsLibsLinks 
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    opDo vis_icmsRunEnvsPreps
    opDo vis_icmsRunEnvLinks    

    opDo vis_icmsLibsLinks
}

_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsPkgClean    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsPkgClean {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
** Invokes: vis_icmsPkgBaseLinksRemove vis_icmsLibsLinksRemove
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]
    
    opDo vis_icmsRunEnvLinksRemove
    
    opDo vis_icmsLibsLinksRemove
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsPanelsPreps    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsPanelsPreps {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    #EH_assert [[ $# -eq 0 ]]
    
    local iimsList=""
    
    if [ $# -eq 0 ] ; then
	iimsList=$(cat _iimsList)
    else
	iimsList="$@"
    fi
    
    if [ -z "${iimsList}" ] ; then
	ANT_raw "Missing or Empty _iimsList -- panelsPreps skipped"
	lpReturn
    fi

    for oneFile in ${iimsList} ; do
	opDo iicmPlayer.sh -h -v -n showRun -i update "${oneFile}"
    done
    
    lpReturn

    echo "NOTYET After lpReturn"
    
    opDo FN_dirCreatePathIfNotThere ./tmp    

    local iimLanguage=""
    local thisIim=""
    for thisIim in ${iimsList}; do
	iimLanguage=$( ${thisIim} -i iimLanguage)
	if [ "${iimLanguage}" == "bash" ] ; then
	    opDo ${thisIim} -h -v -n showRun -i pkgedPanelPreps	    
	elif [ "${iimLanguage}" == "python" ] ; then
	    opDo iicmPlayer.sh -h -v -n showRun -i grouped ${thisIim}
	    #EH_problem "python ${thisIim} -- Notyet"
	else
	    EH_oops ""
	    continue
	fi
    done
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsPanelsClean    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsPanelsClean {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    local iimsList=""
    
    if [ $# -eq 0 ] ; then
	iimsList=$(cat _iimsList)
    else
	iimsList="$@"
    fi
    local thisIim=""
    local panelName=""
    local panelNameBackup=""    
    for thisIim in ${iimsList}; do
	panelName=$(FN_prefix ${thisIim})-Panel.org
	if [ -f "${panelName}" ] ; then
	    opDo rm ${panelName}
	else
	    echo Skipped: Non-Existent ${panelName}
	fi
	panelNameBackup=$( ls ${panelName}.201* 2> /dev/null )
	if [ ! -z "${panelNameBackup}" ] ; then
	    opDo rm ${panelNameBackup} 
	fi
    done
    if [ -d ./var ] ; then
       opDo rm -r ./var
    fi
    opDo FN_fileRmIfThere ./*.pyc
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsRunEnvsPreps    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsRunEnvsPreps {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
** Create run time environment directories (tmp var)
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    local icmsPkgBaseDir=$(icmsPkgBaseDirGet)
    local icmsPkgName=$(icmsPkgNameGet)
    local icmsRunEnvBaseDir=$(icmsRunEnvBaseDirGet)

    opDoRet FN_dirCreatePathIfNotThere "${icmsRunEnvBaseDir}"    

    opDoRet FN_dirCreatePathIfNotThere "${icmsRunEnvBaseDir}/tmp"
    opDoRet FN_dirCreatePathIfNotThere "${icmsRunEnvBaseDir}/tmp/${icmsPkgName}"
    opDoRet FN_dirCreatePathIfNotThere "${icmsRunEnvBaseDir}/var"
    opDoRet FN_dirCreatePathIfNotThere "${icmsRunEnvBaseDir}/var/${icmsPkgName}"    

    lpReturn
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsRunEnvsClean    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsRunEnvsClean {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
** Remove run time environment directories (tmp var)
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    local icmsPkgBaseDir=$(icmsPkgBaseDirGet)
    local icmsPkgName=$(icmsPkgNameGet)
    local icmsRunEnvBaseDir=$(icmsRunEnvBaseDirGet)

    opDo rm -r "${icmsRunEnvBaseDir}/tmp/${icmsPkgName}"
    opDo rm -r "${icmsRunEnvBaseDir}/var/${icmsPkgName}"
    
    lpReturn
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsRunEnvLinks    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsRunEnvLinks {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
** Create links for ../tmp ../var
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    local icmsPkgBaseDir=$(icmsPkgBaseDirGet)
    local icmsPkgName=$(icmsPkgNameGet)
    local icmsRunEnvBaseDir=$(icmsRunEnvBaseDirGet)

    local controlsProfilesBaseDir=$(icmsPkgControlBaseDirGet)
    local controlsBaseDir="${icmsPkgBaseDir}/control"

    if [ ! -d "${controlsProfilesBaseDir}" ] ; then
	EH_problemRet ""
    fi

    if [ -h "${icmsPkgBaseDir}/var" ] ; then
	if [ -h "${icmsPkgBaseDir}/tmp" ] ; then
	    lpReturn 0
	fi
    fi

    opDo FN_fileSymlinkUpdate "${icmsRunEnvBaseDir}/tmp/${icmsPkgName}" "${icmsPkgBaseDir}/tmp"
    opDo FN_fileSymlinkUpdate "${icmsRunEnvBaseDir}/var/${icmsPkgName}" "${icmsPkgBaseDir}/var"

    opDo FN_fileSymlinkUpdate "${controlsProfilesBaseDir}" "${controlsBaseDir}"
    
    lpReturn
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsRunEnvLinksRemove    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsRunEnvLinksRemove {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
** Remove links of ../tmp ../var
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    local icmsPkgBaseDir=$(icmsPkgBaseDirGet)
    local icmsPkgName=$(icmsPkgNameGet)
    local icmsRunEnvBaseDir=$(icmsRunEnvBaseDirGet)

    local controlsBaseDir="${icmsPkgBaseDir}/control"    

    opDo FN_fileSymlinkRemoveIfThere "${icmsPkgBaseDir}/tmp"
    opDo FN_fileSymlinkRemoveIfThere "${icmsPkgBaseDir}/var"

    opDo FN_fileSymlinkRemoveIfThere "${controlsBaseDir}"
    
    lpReturn
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsLibsLinks    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsLibsLinks {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
** Creates links in ../lib/python/
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    local icmsPkgBaseDir=$(icmsPkgBaseDirGet)
    local icmsPkgName=$(icmsPkgNameGet)

    if [ -h ${icmsPkgBaseDir}/lib/python/iicm ] ; then
	if [ -h ${icmsPkgBaseDir}/lib/python/bxMsg ] ; then
	    lpReturn 0
	fi
    fi

    opDo FN_fileSymlinkUpdate /de/bx/nne/dev-py/libs/iicmPkg/iicm ${icmsPkgBaseDir}/lib/python/iicm
    opDo FN_fileSymlinkUpdate /de/bx/nne/dev-py/libs/bxMsgPkg/bxMsg ${icmsPkgBaseDir}/lib/python/bxMsg
    
    lpReturn
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsLibsLinksRemove    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsLibsLinksRemove {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
** Remove links in ../lib/python/
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    local icmsPkgBaseDir=$(icmsPkgBaseDirGet)
    local icmsPkgName=$(icmsPkgNameGet)
    local icmsRunEnvBaseDir=$(icmsRunEnvBaseDirGet)

    opDo FN_fileSymlinkRemoveIfThere ${icmsPkgBaseDir}/lib/python/iicm
    opDo FN_fileSymlinkRemoveIfThere ${icmsPkgBaseDir}/lib/python/bxMsg    
    
    lpReturn
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_icmsPkgTarUpdateAtPlpc    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_icmsPkgTarUpdateAtPlpc {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
** Creates tar files in /lcnt/lgpc/bystar/permanent/facilities
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]


    local icmsPkgBaseDir=$(icmsPkgBaseDirGet)
    local icmsPkgName=$(icmsPkgNameGet)
    local icmsRunEnvBaseDir=$(icmsRunEnvBaseDirGet)

    # NOTYET, get controlBase from FPs
    local marmeControlBaseDir=$( FN_absolutePathGet ../../marme.control )

    local tarDestBaseDir="/lcnt/lgpc/bystar/permanent/facilities/marmee"

    opDo tarPkgManage.sh -h -v -n showRun -p inBase="${icmsPkgBaseDir}" -p outBase="marme" -p result="${tarDestBaseDir}/marme.tar"  -i basesCombine

    opDo tarPkgManage.sh -h -v -n showRun -p inBase="${marmeControlBaseDir}" -p outBase="marme.control" -p result="${tarDestBaseDir}/marmeControl.tar"  -i basesCombine common example.com

    opDo echo "Run fullUpdate in /lcnt/lgpc/bystar/permanent/facilities/marmee"
    
    lpReturn
}

_CommentBegin_
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]  *ICMs Control*
_CommentEnd_


_CommentBegin_
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]  *Transitions*
_CommentEnd_


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_old2New    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_old2New {

    #ANT_raw "Edit this script to suit your search string and comment the return 0 line"
    #return 0

    filesListOLD="
inMailDsnProc.py
inMailRetrieve.py
inMailUserAgent.py
mailAcctsLib.py
marmeAcctsManage.py
outMailSend.py
pkgManage.py
"
    
    filesListO2="
marmeRuns.py
marmeSendIcm.py
marmeTrackingIcm.py
marmeTrackingLib.py
"
    filesList="
marmeSendLib.py
"

    
    #for oneFile in ${filesList} ; do
	#opDo /bin/rm ${oneFile}
    #done

    #return

    #set -x
    for oneFile in ${filesList} ; do
	#print ${oneFile}
	opDo cp ${oneFile} ${oneFile}.$$
	cat ${oneFile}.$$ | sed \
				-e "s%mailAcctsLib%marmeAcctsLib%g" > ${oneFile}
	#opDo /bin/rm ${oneFile}
    done
}


function vis_old2NewBase2Acct {

    #ANT_raw "Edit this script to suit your search string and comment the return 0 line"
    #return 0

    filesList="
inMailDsnProc.py
inMailRetrieve.py
inMailUserAgent.py
mailAcctsLib.py
mailAcctsManage.py
outMailSend.py
pkgManage.py
"

    #for oneFile in ${filesList} ; do
	#opDo /bin/rm ${oneFile}
    #done

    #return

    #set -x
    for oneFile in ${filesList} ; do
	#print ${oneFile}
	opDo cp ${oneFile} ${oneFile}.$$
	cat ${oneFile}.$$ | sed \
				-e "s%inMailBase%inMailAcct%g" \
				-e "s%outMailBase%outMailAcct%g" \
				-e "s%defaultMailBase%defaultMailAcct%g" \
				-e "s%maildirPath%inMailAcctMboxesPath%g" \
				-e "s%outMailControls%outMailAcctAccessPars%g" \
				-e "s%inMailControls%inMailAcctAccessPars%g" \
				-e "s%commonMail%mailAcctsLib%g" > ${oneFile}
	#opDo /bin/rm ${oneFile}
    done
}


_CommentBegin_
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]  *Junk Yard*
_CommentEnd_


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_varIimsPkgPrep    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_varIimsPkgPrep {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]
    
    opDo fileParamManage.py -i fileParamWrite ./iimsIn/control iimsPkgLabel  $(FN_nonDirsPart $(pwd))
    opDo fileParamManage.py -i fileParamWrite ./iimsIn/control dateVer "uninitialized"    

    
    if [ $# -eq 0 ] ; then
	iimsList=$(cat _iimsList)
    else
	iimsList="$@"
    fi

    opDo FN_dirCreatePathIfNotThere ./tmp    

    local iimLanguage=""
    local thisIim=""
    for thisIim in ${iimsList}; do
	iimLanguage=$( ${thisIim} -i iimLanguage)
	if [ "${iimLanguage}" == "bash" ] ; then
	    opDo ${thisIim} -h -v -n showRun -i pkgedPanelPreps	    
	elif [ "${iimLanguage}" == "python" ] ; then
	    EH_problem "python ${thisIim} -- Notyet"
	else
	    EH_oops ""
	    continue
	fi
    done
}



_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_pkgInitObsoleted    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_pkgInitObsoleted {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    if [ -d "./tmp" ] ; then
	opDo mv ./tmp ./tmp.${dateTag}
    fi
    FN_dirCreatePathIfNotThere ./tmp
    opDo fileParamManage.py -i fileParamWrite ./tmp dateVer "uninitialized"

    if [ -d "./iimsIn" ] ; then
	opDo mv ./iimsIn ./iimsIn.${dateTag}
    fi
    FN_dirCreatePathIfNotThere ./iimsIn
    FN_dirCreatePathIfNotThere ./iimsIn/control
    opDo fileParamManage.py -i fileParamWrite ./iimsIn/control iimsPkgLabel  $(FN_nonDirsPart $(pwd))
    opDo fileParamManage.py -i fileParamWrite ./iimsIn/control dateVer "uninitialized"    

    FN_dirCreatePathIfNotThere ./iimsIn/targets
    FN_dirCreatePathIfNotThere ./iimsIn/proxies    

    if [ -d "./iimsOut" ] ; then
	opDo mv ./iimsOut ./iimsOut.${dateTag}
    fi
    FN_dirCreatePathIfNotThere ./iimsOut

    opDo vis_defaultsTargetsAndParamsSet    

    lpReturn

    opDo vis_selectionsPanelPrep

    opDo iimsProc.sh -h -v -n showRun  -p liTargetsDotpy=/de/bx/current/district/librecenter/tiimi/targets/bxp/tList/ts-librecenter-localhost.py -p liParamsDotpy=/de/bx/current/district/librecenter/tiimi/targets/bxp/paramList/bxpUsageParams.py -i effectiveLisSet    
}



_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_pkgDistCleanObsoleted    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_pkgDistCleanObsoleted {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
NOTYET, 
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]
    #describeF

    opDo FN_dirRemoveIfThere ./var

    opDo FN_dirRemoveIfThere ./tmp

    lpReturn    

    #opDo vis_effectiveLisClean 
    #opDo FN_fileSymlinkRemoveIfThere ./liTargets.py
    #opDo FN_fileSymlinkRemoveIfThere ./liParams.py

    #opDo vis_selectionsPanelClean    
    #opDo FN_fileSymlinkRemoveIfThere ./panelSelects

    #opDo FN_dirRemoveIfThere ./output  ./outputFiles ./outputFiles__main__
    
    #opDo FN_dirRemoveIfThere ./data_cache

    #opDo FN_dirRemoveIfThere ./inputFiles

    #opDo FN_dirRemoveIfThere ./iimsOut  

    #opDo FN_fileRmIfThere ./eml-*.org                 
    
    lpReturn
}


_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  vis_panelsPrepsOld    [[elisp:(org-cycle)][| ]]
_CommentEnd_

function vis_panelsPrepsOld {
    G_funcEntry
    function describeF {  G_funcEntryShow; cat  << _EOF_
_EOF_
    }
    EH_assert [[ $# -eq 0 ]]

    typeset tmpFile=$( FN_tempFile )

    typeset selectedIim=$( cat ./_selectedIim )

    if [ -z ${selectedIim} ] ; then
	ANT_raw "Missing _selectedIim -- panelsPreps skipped"
	lpReturn
    fi

    cat  ./Panel.org  | sed  \
	-e "s:@selectedIim@:${selectedIim}:" \
        >> ${tmpFile}

    opDo mv ${tmpFile} ./Panel.org
    
    lpReturn
}


_CommentBegin_
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]  *End Of Editable Text*
_CommentEnd_

####+BEGIN: bx:dblock:bash:end-of-file :types ""
_CommentBegin_
*  [[elisp:(org-cycle)][| ]]  Common        ::  /[dblock] -- End-Of-File Controls/ [[elisp:(org-cycle)][| ]]
_CommentEnd_
#+STARTUP: showall
#local variables:
#major-mode: sh-mode
#fill-column: 90
# end:
####+END:
