#! /usr/bin/env python
# -*- coding: utf-8 -*-
"""\
*    *[Summary]* ::  Given a mailFile, Let this IICM do its processing
"""
"""
####+BEGINNOT: bx:dblock:global:file-insert-cond :cond "./blee.el" :file "/libre/ByStar/InitialTemplates/software/plusOrg/dblock/inserts/topControls.org"
* 
*  An Interactively Invokable Command Module (IICM) :: Best Used With Blee-IICM-Players in Emacs -- Part Of ByStar
####+END:
"""
"""
*  [[elisp:(org-cycle)][| *IICM-INFO:* |]]
"""
####+BEGINNOT: bx:dblock:global:iim:name-py :style "fileName"
__iicmName__ = "mboxRetrieve"
####+END:

####+BEGIN: bx:dblock:global:timestamp:version-py :style "date"
__version__ = "201706241205"
####+END:

# NOTYET dblk-begin
__status__ = "Production"
# NOTYET dblk-end

__credits__ = [""]

# NOTYET dblk-begin
iicmInfo = {
    'authors':         ["[[http://mohsen.1.banan.byname.net][Mohsen Banan]]"],
    'copyright':       "Copyright 2017, [[http://www.neda.com][Neda Communications, Inc.]]",
    'licenses':        ["[[https://www.gnu.org/licenses/agpl-3.0.en.html][Affero GPL]]", "Libre-Halaal Services License", "Neda Commercial License"],
    'maintainers':     ["[[http://mohsen.1.banan.byname.net][Mohsen Banan]]",],
    'contacts':        ["[[http://mohsen.1.banan.byname.net/contact]]",],
    'partOf':          ["[[http://www.by-star.net][Libre-Halaal ByStar Digital Ecosystem]]",]
}
# NOTYET dblk-end

"""
####+BEGINNOT: bx:dblock:global:file-insert-cond :cond "./blee.el" :file "/libre/ByStar/InitialTemplates/software/plusOrg/dblock/inserts/topControls.org"
#*      ================
*  [[elisp:(org-cycle)][|/Controls/| ]] ::  [[elisp:(org-show-subtree)][|=]]  [[elisp:(show-all)][Show-All]]  [[elisp:(org-shifttab)][Overview]]  [[elisp:(progn (org-shifttab) (org-content))][Content]] | [[file:Panel.org][Panel]] | [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] | [[elisp:(bx:org:run-me)][Run]] | [[elisp:(bx:org:run-me-eml)][RunEml]] | [[elisp:(delete-other-windows)][(1)]] | [[elisp:(progn (save-buffer) (kill-buffer))][S&Q]]  [[elisp:(save-buffer)][Save]]  [[elisp:(kill-buffer)][Quit]] [[elisp:(org-cycle)][| ]]
** /Version Control/ ::  [[elisp:(call-interactively (quote cvs-update))][cvs-update]]  [[elisp:(vc-update)][vc-update]] | [[elisp:(bx:org:agenda:this-file-otherWin)][Agenda-List]]  [[elisp:(bx:org:todo:this-file-otherWin)][ToDo-List]] 
*** /More Panels Access ::
####+END:
"""

"""
# NOTYET, Can be dblock
*      ================
*  #################### CONTENTS-LIST ################
#*      ================
"""

"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *Imports*
"""
####+BEGINNOT: bx:dblock:global:file-insert :file "" Add Path As ParameterNOTYET
"""
*  [[elisp:(org-show-subtree)][|=]]  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Func         ::  insertPathForImports    [[elisp:(org-cycle)][| ]]
"""
def insertPathForImports(path):
    import os
    import sys
    absolutePath = os.path.abspath(path)    
    if os.path.isdir(absolutePath):
        sys.path.insert(1, absolutePath)

insertPathForImports("../lib/python/")

####+END:

"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || =Imports=    ::  Imports [[elisp:(org-cycle)][| ]]
"""

import sys
import os
#import time

import mailAcctsLib
import iicm

#import shlex
#import subprocess

#from datetime import datetime

#import re
#import pprint

import email
#import mailbox
import smtplib

#import flufl.bounce

from email.mime.text import MIMEText
#from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from email.MIMEBase import MIMEBase
from email import Encoders

from bxMsg import msgOut
from bxMsg import msgIn
#from bxMsg import msgLib

#import karnickel
#importer = karnickel.install_hook()

#importer.find_module("__macros__").load_module("__macros__")

#from macros.__macros__ import add

import collections


"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *IICM Framework IIFs*
"""

"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || FrmWrk-IIF   ::  describe    [[elisp:(org-cycle)][| ]]
"""
class describe(iicm.Iif):
    """IICM basic description."""

    iifArgsLen={'Min': 0, 'Max':0,}
    
    @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)    
    def iif(self,
            interactive=False,        # Can also be called non-interactively
    ):
        """Provides basic description of this IICM."""

        moduleDescription="""
*       [[elisp:(org-cycle)][| *Description:* | ]]
**  [[elisp:(org-cycle)][| ]]  [Xref]          :: *[Related/Xrefs:]*  <<Xref-Here->>  -- External Documents  [[elisp:(org-cycle)][| ]]

**       Functional Specification :Overview:
**       *[End-Of-Description]*
"""
        if interactive:
            print( str( __doc__ ) )  # This is the Summary: from the top doc-string
            print(moduleDescription)

        return("Version: " + format(str(__version__)) + format(str(__doc__) + moduleDescription))


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || FrmWrk-IIF   ::  usage    [[elisp:(org-cycle)][| ]]
"""
class usage(iicm.Iif):
    """IICM basic usage information."""

    iifArgsLen={'Min': 0, 'Max':0,}
    
    @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)    
    def iif(self,
            interactive=False,        # Can also be called non-interactively
    ):
        """Provides basic usage information for this IICM."""

        moduleDescription="""
*       [[elisp:(org-cycle)][| *Usage:* | ]]

**       See-Also:
***      iicm -i describe
***      iicm -i version
**      *[End-Of-Usage]*
"""
        if interactive:
            print( str( __doc__ ) )  # This is the Summary: from the top doc-string
            #version(interactive=True)
            print(moduleDescription)

        return(format(str(__doc__)+moduleDescription))


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || FrmWrk-IIF   ::  status    [[elisp:(org-cycle)][| ]]
"""
class status(iicm.Iif):
    """IICM current development status."""

    iifArgsLen={'Min': 0, 'Max':0,}
    
    @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)    
    def iif(self,
            interactive=False,        # Can also be called non-interactively
    ):
        """Provides information about current development status of the module including todo and scheduled action items."""

        moduleDescription="""
*       [[elisp:(org-cycle)][| *Status:* | ]]
**  [[elisp:(org-cycle)][| ]]  [Info]          :: *[Current-Info:]* Status/Maintenance -- General TODO List [[elisp:(org-cycle)][| ]]
**  [[elisp:(org-cycle)][| ]]  Current         :: Just getting started [[elisp:(org-cycle)][| ]]

**      *[End-Of-Status]*
"""
        if interactive:
            print( str( __doc__ ) )  # This is the Summary: from the top doc-string
            #version(interactive=True)
            print(moduleDescription)

        return(format(str(__doc__)+moduleDescription))
        


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || FrmWrk-Info  ::  g_iicmChars -- IICM Characteristic Definitions (Grouped/CmndParts)   [[elisp:(org-cycle)][| ]]
"""

def g_iicmChars():
    iicmInfo['panel'] = "G_myName}-Panel.org"
    iicmInfo['groupingType'] = "IimGroupingType-pkged"
    iicmInfo['cmndParts'] = "IimCmndParts[common] IimCmndParts[param]"

g_iicmChars()
    
"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || FrmWrk-Func  ::  g_iicmPreIifs Hook  [[elisp:(org-cycle)][| ]]
"""

@iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
def g_iicmPreIifs():
    #print "PREHOOK"
    pass
    
"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || FrmWrk-Func  ::  g_iicmPostIifs Hook   [[elisp:(org-cycle)][| ]]
"""

@iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
def g_iicmPostIifs():
    #print "POSTHOOK"    
    pass

"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *Options, Arguments and Examples Specifications*
"""


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || =ArgsSpec=   ::  g_argsExtraSpecify    [[elisp:(org-cycle)][| ]]
"""
# Do not decorate with @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
def g_argsExtraSpecify(parser):
    """Module Specific Command Line Parameters.
    g_argsExtraSpecify is passed to G_main and is executed before argsSetup (can not be decorated)
    """
    G = iicm.IicmGlobalContext()
    iicmParams = iicm.IIM_ParamDict()

    #enabledMailAcct = mailAcctsLib.enabledMailAcctObtain()

    mailAcctsLib.commonParamsSpecify(iicmParams)

    iicmParams.parDictAdd(
        parName='moduleVersion',
        parDescription="Module Version",
        parDataType=None,
        parDefault=None,
        parChoices=list(),
        parScope=iicm.IIM_ParamScope.TargetParam,
        argparseShortOpt=None,
        argparseLongOpt='--version',
    )

    iicmParams.parDictAdd(
        parName='inFile',
        parDescription="Input File",
        parDataType=None,
        # ../control/outMail/common/template/bynameUtf8.mail
        parDefault=os.path.join(
            mailAcctsLib.outMailCommonDirGet(),
            "template/bynameUtf8.mail"
        ),            
        parChoices=["someFile", "UserInput"],
        parScope=iicm.IIM_ParamScope.TargetParam,
        argparseShortOpt=None,
        argparseLongOpt='--inFile',
        )
    
    iicmParams.parDictAdd(
        parName='fromLine',
        parDescription="From Line",
        parDataType=None,
        parDefault="someFrom@example.com",
        parChoices=["from@example.com", "UserInput"],
        parScope=iicm.IIM_ParamScope.TargetParam,
        argparseShortOpt=None,
        argparseLongOpt='--fromLine',
        )
    
    iicmParams.parDictAdd(
        parName='toLine',
        parDescription="To Line",
        parDataType=None,
        parDefault="someTo@example.com",
        parChoices=["to@example.com", "UserInput"],
        parScope=iicm.IIM_ParamScope.TargetParam,
        argparseShortOpt=None,
        argparseLongOpt='--toLine',
        )
    
       
    iicm.argsparseBasedOnIimParams(parser, iicmParams)

    # So that it can be processed later as well.
    G.iimParamDictSet(iicmParams)
    
    return


####+BEGINNOT: bx:dblock:global:file-insert :file "/libre/ByStar/InitialTemplates/software/plusOrg/dblock/inserts/G_examplesIim.top.py"
"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || FrmWrk-IIF   ::  examples    [[elisp:(org-cycle)][| ]]
"""
####+END:
class examples(iicm.Iif):
    """Framework compliant examples IIF."""

    iifArgsLen={'Min': 0, 'Max': 0,}

####+BEGIN: bx:dblock:python:iim:iif:parsValidate :par ""
    @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
    def iif(self,
        interactive=False,        # Can also be called non-interactively
    ):
        iifOutcome = self.getOpOutcome()
        if interactive:
            if not self.cmndLineValidate(outcome=iifOutcome):
                return iifOutcome

        callParamsDict = {}
        if not iicm.iifCallParamsValidate(callParamsDict, interactive, outcome=iifOutcome):
            return iifOutcome
####+END:

        iicm.ex_gCommon()

        """
**  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Examples   ::  General Dev and Testing IIFs [[elisp:(org-cycle)][| ]]
"""
        iicm.iifExampleMenuChapter('*General Dev and Testing IIFs*')   

        cmndName = "unitTest" ; cmndArgs = "" ; cps = collections.OrderedDict()        
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='none')

        
        """
**  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Examples   ::  Default Mail From Complete File [[elisp:(org-cycle)][| ]]
"""

        iicm.iifExampleMenuChapter('*Mail From Complete File -- Default Control Profile*')

        cmndName = "sendFromCompleteFile" ; cmndArgs = "" ;        

        inFileExample = '''{fileName}'''.format(
            fileName=os.path.join(
                mailAcctsLib.outMailCommonDirGet(),
                "template/plain/fromValid/toValid/default.mail"
            ))

        cps = collections.OrderedDict() ; cps['inFile'] = inFileExample
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='none')

        cps = collections.OrderedDict() ; cps['runMode'] = "dryRun" ; cps['inFile'] = inFileExample 
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='little')

        """
**  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Examples   ::  FORNOW ByStar Mail From Complete File [[elisp:(org-cycle)][| ]]
"""

        iicm.iifExampleMenuChapter('*FORNOW: ByStar Mail From Complete File*')
        
        inFileExample = '''{fileName}'''.format(
            fileName="/de/bx/nne/mcm0/Sync/marme.control/byStar/outMail/common/template/plain/fromValid/toValid/sa20000ToTest.mail"
            )

        cps = collections.OrderedDict() ; cps['inFile'] = inFileExample
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='none')

        cps = collections.OrderedDict() ; cps['runMode'] = "dryRun" ; cps['inFile'] = inFileExample 
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='little')

        inFileExample = '''{fileName}'''.format(
            fileName="/de/bx/nne/mcm0/Sync/marme.control/byStar/outMail/common/template/plain/fromValid/toBad/sa20000ToBad.mail"
            )

        cps = collections.OrderedDict() ; cps['inFile'] = inFileExample
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='none')

        cps = collections.OrderedDict() ; cps['runMode'] = "dryRun" ; cps['inFile'] = inFileExample 
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='little')

        
        """
**  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Examples   ::  FORNOW Fastrack Mail From Complete File [[elisp:(org-cycle)][| ]]
"""

        iicm.iifExampleMenuChapter('*FORNOW: Fastrack Mail From Complete File*')        

        inFileExample = '''{fileName}'''.format(
            fileName=os.path.join(
                mailAcctsLib.outMailCommonDirGet(),
                "template/bynameUtf8-complete.mail"
            ))

        cps = collections.OrderedDict() ; cps['inFile'] = inFileExample
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='none')

        cps = collections.OrderedDict() ; cps['runMode'] = "dryRun" ; cps['inFile'] = inFileExample 
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='little')
   
        
        """
**  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Examples   ::  Mail From Partial File -- Qmail Inject [[elisp:(org-cycle)][| ]]
"""
        
        iicm.iifExampleMenuChapter('*Mail From Partial File -- Qmail Inject*')

        inFileExample = '''{fileName}'''.format(
            fileName=os.path.join(
                mailAcctsLib.outMailCommonDirGet(),
                "template/bynameUtf8.mail"
            ))

        cmndName = "sendFromPartialFileWithPars" ; cmndArgs = "" ; cps = collections.OrderedDict()        
        cps['submissionMethod'] = "inject" ; cps['inFile'] = inFileExample
        cps['runMode']="dryRun"
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='none')

        """
**  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Examples   ::  Basic Mail Sending  [[elisp:(org-cycle)][| ]]
"""
        
        
        iicm.iifExampleMenuChapter('*Basic Mail Sending*')

        cmndName = "msgSend_basic" ; cmndArgs = "" ; cps = collections.OrderedDict()        
        cps['fromLine']="office@mohsen.1.banan.byname.net" ; cps['toLine']="test@mohsen.banan.1.byname.net"
        iicm.ex_gCmndMenuItem(cmndName, cps, cmndArgs, verbosity='none')

        """
**  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Examples   ::  From  mailAcctsLib.py   [[elisp:(org-cycle)][| ]]
"""

        mailAcctsLib.examples_mailAcctsLibControls()
   
        mailAcctsLib.examples_outMailAcctAccessPars()
        
        return(iifOutcome)

    
####+BEGIN: bx:dblock:global:file-insert :file "/libre/ByStar/InitialTemplates/software/plusOrg/dblock/inserts/G_examples.bottom.py"
    # Intentionally Left Blank -- previously: lhip.G_devExamples(G_myName)

####+END:

"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *IICM Specific Interactively Invokable Functions (IICM-IIF)*
"""

"""
*  [[elisp:(org-show-subtree)][=|=]] [[elisp:(org-cycle)][| ]] [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] || Class-IIF         ::  unitTest    [[elisp:(org-cycle)][| ]]
"""
class unitTest(iicm.Iif):
    """
** Place holder for IICM's experimental or test code. 
    """
    iifArgsLen = {'Min': 0, 'Max': 0,}
    
    @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)    
    def iif(self,
            interactive=False,        # Can also be called non-interactively
    ):
        """Use this IIF for rapid prototyping and testing of newly developed functions.

** TODO Needs to be added to examples.
"""
        
        myName=self.myName()
        #G = iicm.IicmGlobalContext()        
        thisOutcome = iicm.OpOutcome(invokerName=myName)

        print (iicm.__file__)
        print sys.path

        import imp
        print(imp.find_module('iicm'))

        @iicm.runOnceOnly
        def echo(str):
            print str
            
        echo("first")
        echo("second")  # Should not run

        # Install the import hook.
        #from macros import custom_loop
        #with custom_loop(10):
        #   print "I'm looping!"

        SomeEnum = iicm.Enum(
            inject='injectZZ',
            submit='submit',
        )

        print SomeEnum.inject

        return


        print msgOut.InjectionMethod.inject

        print eval("msgOut.InjectionMethod.inject")

        print vars(msgOut.InjectionMethod)

        print msgOut.enumFromStrWhenValid("InjectionMethod", msgOut.InjectionMethod.submit)

        orderedDict2 =iicm.oDict(arg1="value1", arg2="value2")

        print orderedDict2

        print orderedDict2['arg1']

        SomeEnum = iicm.Enum(
            inject='inject',
            submit='submit',
        )

        print SomeEnum.inject
        
        #global add
        return thisOutcome
        #print(type(add))
        #add(1,2)
        #return 

"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *Support Functions For MsgProcs*
"""

"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Class-IIF    ::  sendFromCompleteFile    [[elisp:(org-cycle)][| ]]
"""
class sendFromCompleteFile(iicm.Iif):
    """
** Submit a message using inFile =purely=. 
"""
    
    iifParamsMandatory = ['inFile']
    iifParamsOptional = []        
    iifArgsLen = {'Min': 0, 'Max': 0,}

####+BEGIN: bx:dblock:python:iim:iif:parsValidate :par "inFile"
    @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
    def iif(self,
        interactive=False,        # Can also be called non-interactively
        inFile=None,         # or Cmnd-Input
    ):
        iifOutcome = self.getOpOutcome()
        if interactive:
            if not self.cmndLineValidate(outcome=iifOutcome):
                return iifOutcome

        callParamsDict = {'inFile': inFile, }
        if not iicm.iifCallParamsValidate(callParamsDict, interactive, outcome=iifOutcome):
            return iifOutcome
        inFile = callParamsDict['inFile']
####+END:
        
        #G = iicm.IicmGlobalContext()
        
        if inFile:
            msg = msgIn.getMsgFromFile(inFile)
        else:
            # Stdin then
            msg = msgIn.getMsgFromStdin()

        iicm.LOG_here(msgOut.strLogMessage(
            "Msg As Read From File:", msg,))

        outcome = msgSendingPipelineLoadFromMsg(msg)
        if outcome.isProblematic(): return(iicm.EH_badOutcome(outcome))
        
        if outcome.results != "INCOMPLETE":
            iicm.LOG_here("Complete Message Being Sent")
            return (
                msgOut.sendBasedOnHeadersInfo(msg)
            )

        iicm.LOG_here("Incomplete Message -- using qmail+dryrun")

        msgOut.injectionParams(
            msg,
            injectionProgram=msgOut.InjectionProgram.qmail,
            sendingRunControl=msgOut.SendingRunControl.dryRun,        
        )

        return msgOut.sendBasedOnHeadersInfo(msg)

"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Class-IIF    ::  sendFromPartialFileWithPars    [[elisp:(org-cycle)][| ]]
"""    
class sendFromPartialFileWithPars(iicm.Iif):
    """
** Submit a message using inFile and pars: outMailAcct, submissionMethod. 
"""
    
    iifParamsMandatory = []
    iifParamsOptional = ['outMailAcct', 'inFile', 'submissionMethod']        
    iifArgsLen = {'Min': 0, 'Max': 0,}

####+BEGIN: bx:dblock:python:iim:iif:parsValidate :par "outMailAcct inFile submissionMethod"
    @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
    def iif(self,
        interactive=False,        # Can also be called non-interactively
        outMailAcct=None,         # or Cmnd-Input
        inFile=None,         # or Cmnd-Input
        submissionMethod=None,         # or Cmnd-Input
    ):
        iifOutcome = self.getOpOutcome()
        if interactive:
            if not self.cmndLineValidate(outcome=iifOutcome):
                return iifOutcome

        callParamsDict = {'outMailAcct': outMailAcct, 'inFile': inFile, 'submissionMethod': submissionMethod, }
        if not iicm.iifCallParamsValidate(callParamsDict, interactive, outcome=iifOutcome):
            return iifOutcome
        outMailAcct = callParamsDict['outMailAcct']
        inFile = callParamsDict['inFile']
        submissionMethod = callParamsDict['submissionMethod']
####+END:
        
        G = iicm.IicmGlobalContext()

        submissionMethodEnum =  msgOut.enumFromStrWhenValid("SendingMethod", submissionMethod)

        if submissionMethodEnum == None:
            return (
                iicm.EH_problem_info("""Bad Input: {submissionMethod}"""
                                     .format(submissionMethod=submissionMethod)
                ))

        outcome = mailAcctsLib.outMailAcctParsGet().iif(
            interactive=False,
            outMailAcct=outMailAcct,
            parTypes=['access'],
        )
        if outcome.isProblematic(): return(iicm.EH_badOutcome(outcome))

        fp_access_dict = outcome.results

        outcome = mailAcctsLib.outMailAcctParsGet().iif(
            interactive=False,
            outMailAcct=outMailAcct,
            parTypes=['controllerInfo'],
        )
        if outcome.isProblematic(): return(iicm.EH_badOutcome(outcome))

        fp_controllerInfo_dict = outcome.results

        outcome = mailAcctsLib.outMailAcctParsGet().iif(
            interactive=False,
            outMailAcct=outMailAcct,
            parTypes=['submission'],
        )
        if outcome.isProblematic(): return(iicm.EH_badOutcome(outcome))

        fp_submission_dict = outcome.results
        
        if G.usageParams.inFile:
            msg = msgIn.getMsgFromFile(G.usageParams.inFile)
        else:
            # Stdin then
            msg = msgIn.getMsgFromStdin()

        #print msg

        envelopeAddr = fp_submission_dict["envelopeAddr"].parValueGet()

        newEmployeeEmailAddr = "John Doe <johndoe22@gmail.com>"


        msgOut.envelopeAddrSet(
            msg,
            mailBoxAddr=envelopeAddr,  # Mandatory
        )

        msgOut.crossRefInfo(
            msg,
            crossRefInfo="peepid comes here"  # Mandatory
        )
        msgOut.nonDeliveryNotificationRequetsForTo(
            msg,
            recipientsList=[newEmployeeEmailAddr],        
            notifyTo=envelopeAddr,
        )
        msgOut.nonDeliveryNotificationActions(
            msg,
            coRecipientsList=[newEmployeeEmailAddr],        
        )
        msgOut.deliveryNotificationRequetsForTo(
            msg,
            recipientsList=[newEmployeeEmailAddr],
            notifyTo=envelopeAddr,
        )
        msgOut.dispositionNotificationRequetsForTo(
            msg,
            recipientsList=[newEmployeeEmailAddr],        
            notifyTo=envelopeAddr,
        )

        outcome = msgSendingPipelineLoadFromMsg(msg)
        if outcome.results != "INCOMPLETE":
            return (
                msgOut.sendBasedOnHeadersInfo(msg)
            )

        msgOut.injectionParams(
            msg,
            injectionProgram=msgOut.InjectionProgram.qmail,
            sendingRunControl=msgOut.SendingRunControl.dryRun,        
        )

        return msgOut.sendBasedOnHeadersInfo(msg)


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Class-IIF    ::  msgSend_basic    [[elisp:(org-cycle)][| ]]
"""
class msgSend_basic(iicm.Iif):
    """."""

    iifParamsMandatory = ['fromLine', 'toLine']
    iifParamsOptional = ['submissionMethod']      
    iifArgsLen = {'Min': 1, 'Max':1000,}

####+BEGIN: bx:dblock:python:iim:iif:parsValidate :par "fromLine toLine submissionMethod"
    @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
    def iif(self,
        interactive=False,        # Can also be called non-interactively
        fromLine=None,         # or Cmnd-Input
        toLine=None,         # or Cmnd-Input
        submissionMethod=None,         # or Cmnd-Input
    ):
        iifOutcome = self.getOpOutcome()
        if interactive:
            if not self.cmndLineValidate(outcome=iifOutcome):
                return iifOutcome

        callParamsDict = {'fromLine': fromLine, 'toLine': toLine, 'submissionMethod': submissionMethod, }
        if not iicm.iifCallParamsValidate(callParamsDict, interactive, outcome=iifOutcome):
            return iifOutcome
        fromLine = callParamsDict['fromLine']
        toLine = callParamsDict['toLine']
        submissionMethod = callParamsDict['submissionMethod']
####+END:

        msg = MIMEMultipart()

        msg['From'] = fromLine
        msg['To'] = toLine

        msg['Subject'] = """Some Subject"""

        msg.preamble = 'Multipart massage.\n'

        part = MIMEText(
            """ A message sent to xxx bounced --Hi, please find the attached file\n"""
        )
        msg.attach(part)

        part = MIMEBase('application', "octet-stream")
        part.set_payload(open("/etc/resolv.conf", "rb").read())
        Encoders.encode_base64(part)

        part.add_header('Content-Disposition', 'attachment; filename="/etc/resolv.conf"')

        msg.attach(part)

        msgSend_submitWith_byName_sa20000(
            msg=msg,
            envelopeAddr="test@mohsen.banan.1.byname.net",
            recipients=[toLine],
        )

        return


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Submit       ::  OBSOLETED -- msgSend_submitWith_byName_sa20000    [[elisp:(org-cycle)][| ]]
"""
@iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)
def msgSend_submitWith_byName_sa20000(
        msg,
        envelopeAddr,
        recipients,
):
    """Submit or Inject msg using this particular method """

    if iicm.iimRunArgs_isRunModeDryRun():
        print "DryRun of msgSend_submitWith_byName_sa20000"
        print("envelopeAddr= {envelopeAddr}".format(envelopeAddr=envelopeAddr))
        print("recipients= {recipients}".format(recipients=recipients))        
        print("---------------")
        print msg.as_string()
        return

    def getUserName():
        return(
            iicm.FILE_ParamValueReadFrom(
                parRoot="./var/mboxRetrieve.sh/iimsIn/paramsFp",
                parName="userName")
        )

    def getUserPasswd():
        return(
            iicm.FILE_ParamValueReadFrom(
                parRoot="./var/mboxRetrieve.sh/iimsIn/paramsFp",
                parName="userPasswd")
        )
        
    smtpConn = smtplib.SMTP_SSL('smtp.mohsen.1.banan.byname.net')
    #smtpConn.set_debuglevel(True)
    smtpConn.login(
        getUserName(),
        getUserPasswd(),
    )
    smtpConn.sendmail(envelopeAddr, recipients, msg.as_string())
    smtpConn.quit()

    iicm.ANN_here(
        "Message Sent To: {recipients}".format(recipients=recipients) 
    )

    return


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Class-IIF    ::  shortExample    [[elisp:(org-cycle)][| ]]
"""
class shortExample(iicm.Iif):
    """Submit A Message using qInject."""
    
    iifArgsLen = {'Min': 0, 'Max':0,}
    
    @iicm.subjectToTracking(fnLoc=True, fnEntry=True, fnExit=True)    
    def iif(self,
            interactive=False,        # Can also be called non-interactively
    ):
        """Notyet -- more details to come."""
        
        myName=self.myName()
        #G = iicm.IicmGlobalContext()        
        thisOutcome = iicm.OpOutcome(invokerName=myName)
        if interactive:
            if not self.cmndLineValidate(outcome=thisOutcome):
                return(thisOutcome)

        envelopeAddr = config.config["outmail"]["envelopeAddr"]

        fromLine = '"Hiring Company" <hrDept@company.fasttrackhr.com>'

        newEmployeeEmailAddr = '"John Doe" <johndoe22@gmail.com>'
        secondToAddr = '"Second To" <secondto@example.com>'    
        hiringManager = '"Hiring Manager" <hiringmanager@example.com>'
        hrPerson = '"HR Person" <hrperson@example.com>'

        peepId = "peepid comes here"

        ###

        msg = email.message.Message()  #msg = MIMEText() # MIMEMultipart()    

        msg['Date'] = email.utils.formatdate(localtime = 1)
        msg['Message-ID'] = email.utils.make_msgid()

        msg['Subject'] = """Some Job Offer"""

        msg['From'] = fromLine

        msg['To'] = newEmployeeEmailAddr + ", " + secondToAddr
        msg['CC'] = hiringManager + ", " + hrPerson

        msg.add_header('Content-Type', 'text')
        msg.set_payload(
            """
    Text content of the email comes here.

    This is the last line of text for this email.
    """
        )


        #
        ###########################
        #
        # Above is the real content of the email.
        #
        # We now augment the message with:
        #   - explicit envelope address -- To be used for Delivery-Status-Notifications (DSN)
        #   - The email is be tagged for crossReferencing when DSN is received (e.g. with peepid)    
        #   - Request that non-delivery-reports be acted upon and sent to co-recipients
        #   - Explicit delivery-reports are requested
        #   - Explicit read-receipts are requested
        #   - Injection/Submission parameters are specified
        # The message is then sent out
        #

        msgOut.envelopeAddrSet(
            msg,
            mailBoxAddr=envelopeAddr,  # Mandatory
        )

        #
        # peepId will be used to crossRef StatusNotifications
        #
        msgOut.crossRefInfo(
            msg,
            crossRefInfo=peepId  # Mandatory
        )

        #
        # Delivery Status Notifications will be sent to notifyTo=envelopeAddr
        #
        msgOut.nonDeliveryNotificationRequetsForTo(
            msg,
            notifyTo=envelopeAddr,
        )

        #
        # In case of Non-Delivery, coRecipientsList will be informed
        #
        msgOut.nonDeliveryNotificationActions(
            msg,
            coRecipientsList=[hiringManager, hrPerson],        
        )

        #
        # Explicit Delivery Report is requested
        #
        msgOut.deliveryNotificationRequetsForTo(
            msg,
            recipientsList=[newEmployeeEmailAddr, secondToAddr],
            notifyTo=envelopeAddr,
        )

        #
        # Explicit Read Receipt is requested
        #    
        msgOut.dispositionNotificationRequetsForTo(
            msg,
            recipientsList=[newEmployeeEmailAddr],        
            notifyTo=envelopeAddr,
        )

        #
        # Mail is to be injected with following parameters
        # coming from config.py
        #    
        msgOut.injectionParams(
            msg,
            injectionMethod=config.config["outmail"]["injectionMethod"],       # Mandatory
            mtaRemProtocol=config.config["outmail"]["mtaRemProtocol"],         # Mandatory
            mtaRemHost=config.config["outmail"]["mtaRemHost"],                 # Mandatory
            injectionControl=config.config["outmail"]["injectionControl"],        
        )

        #
        # Mail is to be sentout based on what has been
        # placed in the Mail-Headers-Pipeline. msg contains all necessary info.
        #
        errsReport = msgOut.injectBasedOnHeadersInfo(
            msg,
        )

        return errsReport


"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *Supporting Classes And Functions*
*   /None/  [[elisp:(org-cycle)][| ]]
"""
    

"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *Common/Generic Facilities -- Library Candidates*
*   /None/  [[elisp:(org-cycle)][| ]]
"""
def msgSendingPipelineLoadFromMsg(
        msg,
):
    """.
"""
    opOutcome = iicm.OpOutcome()
    if 'BX-Send-WithAcctName' in msg:
        outMailAcct = msg['BX-Send-WithAcctName']
        return (
            msgSendingPipelineLoadFromAcct(
                msg,
                outMailAcct,
            ))
    elif 'BX-Send-WithBaseDir' in msg:
        acctBaseDir = msg['BX-Send-WithBaseDir']
        return (
            msgSendingPipelineLoadFromAcctBaseDir(
                msg,
                acctBaseDir,
            ))
    else:
        return opOutcome.set(opResults='INCOMPLETE')


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  msgSendingPipelineLoadFromAcct    [[elisp:(org-cycle)][| ]]
"""    
def msgSendingPipelineLoadFromAcct(
        msg,
        outMailAcct,
):
    """
** Just call with obtained base for acct.
    """
    acctBaseDir = mailAcctsLib.outMailAcctDirGet(outMailAcct)
    return (
        msgSendingPipelineLoadFromAcctBaseDir(
            msg,
            acctBaseDir,
        ))

"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || IIF       ::  msgSendingPipelineLoadFromAcctBaseDir    [[elisp:(org-cycle)][| ]]
"""
def msgSendingPipelineLoadFromAcctBaseDir(
        msg,
        acctBaseDir,
):
    """
** Read File Params for mailAcct and set X822-MSP params accordingly
    """
    opOutcome = iicm.OpOutcome()
    #print acctBaseDir
    G = iicm.IicmGlobalContext()

    outcome = iicm.FP_readTreeAtBaseDir().iif(
        interactive=False,
        FPsDir=os.path.join(acctBaseDir, 'access'),
    )
    fp_access_dict = outcome.results

    outcome = iicm.FP_readTreeAtBaseDir().iif(
        interactive=False,
        FPsDir=os.path.join(acctBaseDir, 'controllerInfo'),
    )
    fp_controllerInfo_dict = outcome.results
    
    outcome = iicm.FP_readTreeAtBaseDir().iif(
        interactive=False,
        FPsDir=os.path.join(acctBaseDir, 'submission'),
    )
    fp_submission_dict = outcome.results

    envelopeAddr = fp_submission_dict["envelopeAddr"].parValueGet()
    
    msgOut.envelopeAddrSet(
        msg,
        mailBoxAddr=envelopeAddr,  # Mandatory
    )

    sendingMethod = fp_submission_dict["sendingMethod"].parValueGet()

    if msgOut.sendingMethodSet(msg, sendingMethod).isProblematic():
        return iicm.EH_badLastOutcome()

    if sendingMethod == msgOut.SendingMethod.inject:
        return opOutcome

    #
    # So, It is a submission 
    #
    # NOTYET, below should be split and use
    #  msgOut.submitParamsNOT()
    #

    try:
        mtaRemHost = fp_access_dict["mtaRemHost"].parValueGet()
    except  KeyError:
        return iicm.eh_problem_usageError(opOutcome, "Missing BX-MTA-Rem-Host")

    try:
        userName = fp_access_dict["userName"].parValueGet()
    except  KeyError:
        return iicm.eh_problem_usageError(opOutcome, "Missing BX-MTA-Rem-User")

    try:
        userPasswd = fp_access_dict["userPasswd"].parValueGet()
    except  KeyError:
        return iicm.eh_problem_usageError(opOutcome, "Missing BX-MTA-Rem-Passwd")

    try:
        remProtocol = fp_access_dict["mtaRemProtocol"].parValueGet()        
    except  KeyError:
        return iicm.eh_problem_usageError(opOutcome, "Missing BX-MTA-Rem-Protocol")
    
    try:
        remPortNu = fp_access_dict["mtaRemPortNu"].parValueGet()
    except  KeyError:
        remPortNu = None

    msgOut.submitParams(
        msg,
        mtaRemProtocol=remProtocol,          # smtp
        mtaRemHost=mtaRemHost,              # Remote Host To Submit to (could be localhost)
        mtaRemPort=remPortNu,
        mtaRemUser=userName,        
        mtaRemPasswd=userPasswd,
        mtaRemCerts=None,
    )
    
    return opOutcome
    

"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *G_main -- Instead Of IICM-IIF Dispatcher-Example*
"""


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Func         ::  G_main -- iicm argsparse bypass  [[elisp:(org-cycle)][| ]]
"""

def G_main():
    """ For use instead of IIF dispatcher. Unused unless examples is None."""
    print sys.argv
    #argc = len(sys.argv)
    return



"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *IICM Framework Model Selection And Entry --*
"""


"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || Configure    ::  g_ iicm Mode Specification    [[elisp:(org-cycle)][| ]]
"""

g_examples = examples     # or None -- When None, G_main is invoked
g_mainEntry = G_main      # or None -- Unused unless examples is None
g_importedIifs = {        # Enumerate modules from which IIFs become invokable
   'mailAcctsLib': mailAcctsLib.__file__,
}


"""
#*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *Python Main*
"""

####+BEGINNOT: bx:dblock:global:file-insert :file "/libre/ByStar/InitialTemplates/software/plusOrg/dblock/inserts/iicm.G_main.py"
"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || /Dblk-Begin/ ::  g_iicmMain Func  (Python Main)   [[elisp:(org-cycle)][| ]]
"""

def classedIifsDict():
    """Should be done here, can not be done in iicm library."""
    callDict = dict()
    for eachIif in iicm.iifList_mainsMethods().iif(
            interactive=False,
            importedIifs=g_importedIifs,
    ):
        try:
            callDict[eachIif] = eval("{}".format(eachIif))
            continue
        except NameError:
            pass
        
        for mod in g_importedIifs:       
            try:
                callDict[eachIif] = eval("{mod}.{iif}".format(mod=mod, iif=eachIif))
                break
            except NameError:
                pass
    return callDict


def funcedIifsDict():
    """Should be done here, can not be done iicm library."""
    callDict = dict()
    for eachIif in iicm.iifList_mainsFuncs().iif(interactive=False):
        try:
            callDict[eachIif] = eval("{eachIif}".format(eachIif=eachIif))
        except NameError:
            pass
    return callDict

iicmInfo['iicmName'] = __iicmName__
iicmInfo['version'] = __version__
iicmInfo['status'] = __status__
iicmInfo['credits'] = __credits__
# NOTYET, pass along iicmInfo

def g_iicmMain():
    """This IICM's specific information is passed to G_mainWithClass"""
    sys.exit(
        iicm.G_mainWithClass(
            inArgv=sys.argv[1:],                 # Mandatory
            extraArgs=g_argsExtraSpecify,        # Mandatory
            G_examples=g_examples,               # Mandatory            
            classedIifsDict=classedIifsDict(),   # Mandatory
            funcedIifsDict=funcedIifsDict(),     # Mandatory
            mainEntry=g_mainEntry,
        )
    )

g_iicmMain()

"""
*  [[elisp:(org-cycle)][| ]]  [[elisp:(blee:ppmm:org-mode-toggle)][Nat]] [[elisp:(beginning-of-buffer)][Top]] [[elisp:(delete-other-windows)][(1)]] || /Dblk-End/   ::   [[elisp:(org-cycle)][| ]]
"""
####+END:

"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *Unused Facilities -- Temporary Junk Yard*
"""

"""
*  [[elisp:(beginning-of-buffer)][Top]] ################ [[elisp:(delete-other-windows)][(1)]]      *End Of Editable Text*
"""

"""
*  [[elisp:(org-cycle)][| ]]  [COMMON]      :: /[dblock] -- End-Of-File Controls/ [[elisp:(org-cycle)][| ]]
"""

####+BEGIN: bx:dblock:global:file-insert-cond :cond "./blee.el" :file "/libre/ByStar/InitialTemplates/software/plusOrg/dblock/inserts/endOfFileControls.org"
#+STARTUP: showall

####+END:
